/** @file   BaseContainer.h
 * @brief   Declaration of BaseContainer class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/02/21 20:45:13 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_BaseContainer_H
#define H_ENG2D_BaseContainer_H

#include "eng2d_dll.h"

namespace eng2d {


/** @class  BaseContainer
 * @brief   Baseclass of the containers that can be stored in DataWarehouse.
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT BaseContainer
{
public:

    ///
    /// Constants, datatypes and static methods
    /// =======================================


    ///
    /// Constructors, destructor and operators
    /// ======================================

    /** Default constructor.
     */
    BaseContainer();

    /** Destructor
     */
    virtual ~BaseContainer();

private:
  
    /** Copy constructor
     * @param   aAnother          Reference to another BaseContainer
     */
    BaseContainer( const BaseContainer& aAnother );

    /** An assignment operator
     * @param   aAnother          Reference to another BaseContainer
     * @return  Reference to this object.
     */
    BaseContainer& operator= ( const BaseContainer& aAnother );

public:

    ///
    /// Inherited methods
    /// =================


    ///
    /// New public methods
    /// ==================

    /** Erases the contents of this container.
     */
    virtual void ResetAndDestroy() = 0;
    
    /** Adds the given object to this warehouse item.
     * @param   aObject         Pointer to object being added.
     */
    virtual void Push( void* aObject ) = 0;


    ///
    /// Getter methods
    /// ==============

    /** Returns the data that mathces with given id.
     * @param   aUid            Identifier of the component. With some items
     *                          this could be interpretted as index.
     * @return  Pointer to data that matches with given id. Caller should
     *          typecast this.
     */
    virtual void* At(int aUid) const = 0;


protected:
    ///
    /// Protected interface
    /// ===================


protected:
    ///
    /// Data members
    /// ============

};

};

#endif
